<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$id = $_GET['id'] ?? 0;

// ambil data anggota
$stmt = $db->prepare("SELECT * FROM anggota WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

if (!$data) {
    echo "<p>Data anggota tidak ditemukan</p>";
    exit;
}
?>

<h2>Detail Anggota</h2>

<table class="table">
    <tr>
        <th>No Anggota</th>
        <td><?= $data['no_anggota']; ?></td>
    </tr>
    <tr>
        <th>Nama</th>
        <td><?= $data['nama']; ?></td>
    </tr>
    <tr>
        <th>Alamat</th>
        <td><?= $data['alamat']; ?></td>
    </tr>
    <tr>
        <th>No HP</th>
        <td><?= $data['no_hp']; ?></td>
    </tr>
    <tr>
        <th>Tanggal Daftar</th>
        <td><?= date('d-m-Y', strtotime($data['created_at'])); ?></td>
    </tr>
</table>

<a href="index.php" class="btn btn-primary">Kembali</a>
<a href="edit.php?id=<?= $data['id']; ?>" class="btn btn-warning">Edit</a>

<?php require_once '../../templates/footer.php'; ?>
